<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Notification extends Model 
{

    protected $table = 'notifications';
    public $timestamps = true;
    protected $fillable = array('title', 'content', 'image', 'is_read', 'client_id', 'driver_id');

    public function client()
    {
        return $this->belongsTo('App\Models\Client');
    }

    public function driver()
    {
        return $this->belongsTo('App\Models\Driver');
    }

}